using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Diagnostics;
using System.Threading;

using nsAlienRFID2;

namespace Ex3
{
	public delegate void displayMessageDlgt(string msg);

	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private clsReader mReader;
		private ReaderInfo mReaderInfo;
		private ComInterface meReaderInterface = ComInterface.enumTCPIP;

		#region Auto generated code

		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.NumericUpDown PortUD;
		private System.Windows.Forms.Button btnDisconnect;
		private System.Windows.Forms.Button btnConnect;
		private System.Windows.Forms.Button btnTransact;
		private System.Windows.Forms.Button btnSend;
		private System.Windows.Forms.TextBox textBox2;
		private System.Windows.Forms.GroupBox grpNetwork;
		private System.Windows.Forms.GroupBox grpSerial;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.GroupBox grpConnection;
		private System.Windows.Forms.RadioButton rdoSerial;
		private System.Windows.Forms.RadioButton rdoTCP;
		private System.Windows.Forms.NumericUpDown ReceiveUP;
		private System.Windows.Forms.TextBox txtAsyncResponse;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.TextBox txtSyncResponse;
		private System.Windows.Forms.ComboBox cboPorts;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.RadioButton rdoListenMessages;
		private System.Windows.Forms.RadioButton rdoListenData;
		private System.Windows.Forms.ComboBox cboHostBaudRate;
		private System.Windows.Forms.Label label4;
        private Button btnClear;
        private CheckBox chkKeepAlive;
        private GroupBox groupBox2;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.grpNetwork = new System.Windows.Forms.GroupBox();
            this.textBox1 = new System.Windows.Forms.TextBox();
            this.label2 = new System.Windows.Forms.Label();
            this.PortUD = new System.Windows.Forms.NumericUpDown();
            this.label1 = new System.Windows.Forms.Label();
            this.txtAsyncResponse = new System.Windows.Forms.TextBox();
            this.textBox2 = new System.Windows.Forms.TextBox();
            this.btnDisconnect = new System.Windows.Forms.Button();
            this.btnConnect = new System.Windows.Forms.Button();
            this.btnTransact = new System.Windows.Forms.Button();
            this.btnSend = new System.Windows.Forms.Button();
            this.grpSerial = new System.Windows.Forms.GroupBox();
            this.cboHostBaudRate = new System.Windows.Forms.ComboBox();
            this.label4 = new System.Windows.Forms.Label();
            this.ReceiveUP = new System.Windows.Forms.NumericUpDown();
            this.cboPorts = new System.Windows.Forms.ComboBox();
            this.label8 = new System.Windows.Forms.Label();
            this.label3 = new System.Windows.Forms.Label();
            this.label5 = new System.Windows.Forms.Label();
            this.rdoSerial = new System.Windows.Forms.RadioButton();
            this.rdoTCP = new System.Windows.Forms.RadioButton();
            this.grpConnection = new System.Windows.Forms.GroupBox();
            this.txtSyncResponse = new System.Windows.Forms.TextBox();
            this.label6 = new System.Windows.Forms.Label();
            this.label7 = new System.Windows.Forms.Label();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.rdoListenMessages = new System.Windows.Forms.RadioButton();
            this.rdoListenData = new System.Windows.Forms.RadioButton();
            this.btnClear = new System.Windows.Forms.Button();
            this.chkKeepAlive = new System.Windows.Forms.CheckBox();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.grpNetwork.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.PortUD)).BeginInit();
            this.grpSerial.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.ReceiveUP)).BeginInit();
            this.grpConnection.SuspendLayout();
            this.groupBox1.SuspendLayout();
            this.groupBox2.SuspendLayout();
            this.SuspendLayout();
            // 
            // grpNetwork
            // 
            this.grpNetwork.Controls.Add(this.textBox1);
            this.grpNetwork.Controls.Add(this.label2);
            this.grpNetwork.Controls.Add(this.PortUD);
            this.grpNetwork.Controls.Add(this.label1);
            this.grpNetwork.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
            this.grpNetwork.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.grpNetwork.Location = new System.Drawing.Point(6, 17);
            this.grpNetwork.Name = "grpNetwork";
            this.grpNetwork.Size = new System.Drawing.Size(162, 78);
            this.grpNetwork.TabIndex = 5;
            this.grpNetwork.TabStop = false;
            // 
            // textBox1
            // 
            this.textBox1.Location = new System.Drawing.Point(67, 45);
            this.textBox1.Name = "textBox1";
            this.textBox1.Size = new System.Drawing.Size(87, 20);
            this.textBox1.TabIndex = 10;
            this.textBox1.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(3, 45);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(80, 20);
            this.label2.TabIndex = 9;
            this.label2.Text = "IP Address:";
            // 
            // PortUD
            // 
            this.PortUD.Location = new System.Drawing.Point(67, 12);
            this.PortUD.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this.PortUD.Name = "PortUD";
            this.PortUD.Size = new System.Drawing.Size(60, 20);
            this.PortUD.TabIndex = 8;
            this.PortUD.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.PortUD.Value = new decimal(new int[] {
            23,
            0,
            0,
            0});
            this.PortUD.ValueChanged += new System.EventHandler(this.MyUpDowns_ValueChanged);
            // 
            // label1
            // 
            this.label1.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label1.Location = new System.Drawing.Point(3, 17);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(67, 20);
            this.label1.TabIndex = 6;
            this.label1.Text = "Telnet Port:";
            // 
            // txtAsyncResponse
            // 
            this.txtAsyncResponse.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.txtAsyncResponse.BackColor = System.Drawing.SystemColors.WindowFrame;
            this.txtAsyncResponse.ForeColor = System.Drawing.SystemColors.Info;
            this.txtAsyncResponse.Location = new System.Drawing.Point(32, 328);
            this.txtAsyncResponse.Multiline = true;
            this.txtAsyncResponse.Name = "txtAsyncResponse";
            this.txtAsyncResponse.ScrollBars = System.Windows.Forms.ScrollBars.Both;
            this.txtAsyncResponse.Size = new System.Drawing.Size(520, 216);
            this.txtAsyncResponse.TabIndex = 12;
            // 
            // textBox2
            // 
            this.textBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.textBox2.Location = new System.Drawing.Point(120, 24);
            this.textBox2.Name = "textBox2";
            this.textBox2.Size = new System.Drawing.Size(432, 20);
            this.textBox2.TabIndex = 15;
            // 
            // btnDisconnect
            // 
            this.btnDisconnect.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnDisconnect.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnDisconnect.Enabled = false;
            this.btnDisconnect.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnDisconnect.Location = new System.Drawing.Point(608, 196);
            this.btnDisconnect.Name = "btnDisconnect";
            this.btnDisconnect.Size = new System.Drawing.Size(120, 35);
            this.btnDisconnect.TabIndex = 21;
            this.btnDisconnect.Text = "&Disconnect";
            this.btnDisconnect.UseVisualStyleBackColor = false;
            this.btnDisconnect.Click += new System.EventHandler(this.btnDisconnect_Click);
            // 
            // btnConnect
            // 
            this.btnConnect.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnConnect.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnConnect.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnConnect.Location = new System.Drawing.Point(608, 156);
            this.btnConnect.Name = "btnConnect";
            this.btnConnect.Size = new System.Drawing.Size(120, 35);
            this.btnConnect.TabIndex = 18;
            this.btnConnect.Text = "Co&nnect + Login";
            this.btnConnect.UseVisualStyleBackColor = false;
            this.btnConnect.Click += new System.EventHandler(this.btnConnect_Click);
            // 
            // btnTransact
            // 
            this.btnTransact.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnTransact.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnTransact.Enabled = false;
            this.btnTransact.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnTransact.Location = new System.Drawing.Point(608, 8);
            this.btnTransact.Name = "btnTransact";
            this.btnTransact.Size = new System.Drawing.Size(120, 35);
            this.btnTransact.TabIndex = 17;
            this.btnTransact.Text = "&Transact Synchrounously";
            this.btnTransact.UseVisualStyleBackColor = false;
            this.btnTransact.Click += new System.EventHandler(this.btnTransact_Click);
            // 
            // btnSend
            // 
            this.btnSend.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSend.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnSend.Enabled = false;
            this.btnSend.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnSend.Location = new System.Drawing.Point(608, 48);
            this.btnSend.Name = "btnSend";
            this.btnSend.Size = new System.Drawing.Size(120, 35);
            this.btnSend.TabIndex = 16;
            this.btnSend.Text = "&Send Asynchronously";
            this.btnSend.UseVisualStyleBackColor = false;
            this.btnSend.Click += new System.EventHandler(this.btnSend_Click);
            // 
            // grpSerial
            // 
            this.grpSerial.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSerial.Controls.Add(this.cboHostBaudRate);
            this.grpSerial.Controls.Add(this.label4);
            this.grpSerial.Controls.Add(this.ReceiveUP);
            this.grpSerial.Controls.Add(this.cboPorts);
            this.grpSerial.Controls.Add(this.label8);
            this.grpSerial.Controls.Add(this.label3);
            this.grpSerial.Enabled = false;
            this.grpSerial.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.grpSerial.Location = new System.Drawing.Point(575, 432);
            this.grpSerial.Name = "grpSerial";
            this.grpSerial.Size = new System.Drawing.Size(176, 112);
            this.grpSerial.TabIndex = 22;
            this.grpSerial.TabStop = false;
            this.grpSerial.Text = "Com Port";
            // 
            // cboHostBaudRate
            // 
            this.cboHostBaudRate.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboHostBaudRate.Items.AddRange(new object[] {
            "115200",
            "57600",
            "38400",
            "19200",
            "9600"});
            this.cboHostBaudRate.Location = new System.Drawing.Point(96, 80);
            this.cboHostBaudRate.Name = "cboHostBaudRate";
            this.cboHostBaudRate.Size = new System.Drawing.Size(64, 21);
            this.cboHostBaudRate.TabIndex = 15;
            this.cboHostBaudRate.SelectedIndexChanged += new System.EventHandler(this.cboHostBaudRate_SelectedIndexChanged);
            // 
            // label4
            // 
            this.label4.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label4.Location = new System.Drawing.Point(10, 83);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(100, 16);
            this.label4.TabIndex = 16;
            this.label4.Text = "Host Baud Rate:";
            // 
            // ReceiveUP
            // 
            this.ReceiveUP.Increment = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.ReceiveUP.Location = new System.Drawing.Point(96, 51);
            this.ReceiveUP.Maximum = new decimal(new int[] {
            2147483647,
            0,
            0,
            0});
            this.ReceiveUP.Minimum = new decimal(new int[] {
            60000,
            0,
            0,
            0});
            this.ReceiveUP.Name = "ReceiveUP";
            this.ReceiveUP.Size = new System.Drawing.Size(64, 20);
            this.ReceiveUP.TabIndex = 8;
            this.ReceiveUP.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.ReceiveUP.ThousandsSeparator = true;
            this.ReceiveUP.Value = new decimal(new int[] {
            60000,
            0,
            0,
            0});
            this.ReceiveUP.ValueChanged += new System.EventHandler(this.MyUpDowns_ValueChanged);
            // 
            // cboPorts
            // 
            this.cboPorts.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboPorts.Items.AddRange(new object[] {
            "COM1:",
            "COM2:",
            "COM3:",
            "COM4:",
            "COM5:",
            "COM6:",
            "COM7:",
            "COM8:",
            "COM9:"});
            this.cboPorts.Location = new System.Drawing.Point(96, 22);
            this.cboPorts.Name = "cboPorts";
            this.cboPorts.Size = new System.Drawing.Size(64, 21);
            this.cboPorts.TabIndex = 13;
            this.cboPorts.SelectedIndexChanged += new System.EventHandler(this.cboPorts_SelectedIndexChanged);
            // 
            // label8
            // 
            this.label8.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label8.Location = new System.Drawing.Point(12, 25);
            this.label8.Name = "label8";
            this.label8.Size = new System.Drawing.Size(72, 20);
            this.label8.TabIndex = 14;
            this.label8.Text = "Port Name:";
            // 
            // label3
            // 
            this.label3.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label3.Location = new System.Drawing.Point(10, 46);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(88, 31);
            this.label3.TabIndex = 6;
            this.label3.Text = "Completion Timeout (msec):";
            // 
            // label5
            // 
            this.label5.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label5.Location = new System.Drawing.Point(32, 28);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(100, 20);
            this.label5.TabIndex = 23;
            this.label5.Text = "Command: ";
            // 
            // rdoSerial
            // 
            this.rdoSerial.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoSerial.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoSerial.Location = new System.Drawing.Point(96, 16);
            this.rdoSerial.Name = "rdoSerial";
            this.rdoSerial.Size = new System.Drawing.Size(56, 21);
            this.rdoSerial.TabIndex = 1;
            this.rdoSerial.Text = "Seria&l";
            this.rdoSerial.UseVisualStyleBackColor = false;
            this.rdoSerial.CheckedChanged += new System.EventHandler(this.rdoSerial_CheckedChanged);
            // 
            // rdoTCP
            // 
            this.rdoTCP.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoTCP.Checked = true;
            this.rdoTCP.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoTCP.Location = new System.Drawing.Point(24, 16);
            this.rdoTCP.Name = "rdoTCP";
            this.rdoTCP.Size = new System.Drawing.Size(46, 21);
            this.rdoTCP.TabIndex = 0;
            this.rdoTCP.TabStop = true;
            this.rdoTCP.Text = "TC&P";
            this.rdoTCP.UseVisualStyleBackColor = false;
            this.rdoTCP.CheckedChanged += new System.EventHandler(this.rdoTCP_CheckedChanged);
            // 
            // grpConnection
            // 
            this.grpConnection.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.grpConnection.BackColor = System.Drawing.SystemColors.ControlText;
            this.grpConnection.Controls.Add(this.rdoSerial);
            this.grpConnection.Controls.Add(this.rdoTCP);
            this.grpConnection.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.grpConnection.Location = new System.Drawing.Point(575, 381);
            this.grpConnection.Name = "grpConnection";
            this.grpConnection.Size = new System.Drawing.Size(176, 44);
            this.grpConnection.TabIndex = 24;
            this.grpConnection.TabStop = false;
            this.grpConnection.Text = "Connection";
            // 
            // txtSyncResponse
            // 
            this.txtSyncResponse.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.txtSyncResponse.BackColor = System.Drawing.SystemColors.WindowFrame;
            this.txtSyncResponse.ForeColor = System.Drawing.SystemColors.Info;
            this.txtSyncResponse.Location = new System.Drawing.Point(32, 72);
            this.txtSyncResponse.Multiline = true;
            this.txtSyncResponse.Name = "txtSyncResponse";
            this.txtSyncResponse.ScrollBars = System.Windows.Forms.ScrollBars.Both;
            this.txtSyncResponse.Size = new System.Drawing.Size(520, 216);
            this.txtSyncResponse.TabIndex = 25;
            // 
            // label6
            // 
            this.label6.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label6.Location = new System.Drawing.Point(32, 54);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(140, 19);
            this.label6.TabIndex = 26;
            this.label6.Text = "Synchronous Rersponse: ";
            // 
            // label7
            // 
            this.label7.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label7.Location = new System.Drawing.Point(32, 310);
            this.label7.Name = "label7";
            this.label7.Size = new System.Drawing.Size(147, 14);
            this.label7.TabIndex = 27;
            this.label7.Text = "Asynchronous Rersponse: ";
            // 
            // groupBox1
            // 
            this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox1.BackColor = System.Drawing.SystemColors.ControlText;
            this.groupBox1.Controls.Add(this.rdoListenMessages);
            this.groupBox1.Controls.Add(this.rdoListenData);
            this.groupBox1.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.groupBox1.Location = new System.Drawing.Point(576, 89);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(176, 44);
            this.groupBox1.TabIndex = 28;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "Get";
            // 
            // rdoListenMessages
            // 
            this.rdoListenMessages.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoListenMessages.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoListenMessages.Location = new System.Drawing.Point(87, 16);
            this.rdoListenMessages.Name = "rdoListenMessages";
            this.rdoListenMessages.Size = new System.Drawing.Size(80, 21);
            this.rdoListenMessages.TabIndex = 3;
            this.rdoListenMessages.Text = "Messages";
            this.rdoListenMessages.UseVisualStyleBackColor = false;
            this.rdoListenMessages.CheckedChanged += new System.EventHandler(this.rdoListenMessages_CheckedChanged);
            // 
            // rdoListenData
            // 
            this.rdoListenData.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoListenData.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoListenData.Location = new System.Drawing.Point(24, 16);
            this.rdoListenData.Name = "rdoListenData";
            this.rdoListenData.Size = new System.Drawing.Size(57, 21);
            this.rdoListenData.TabIndex = 2;
            this.rdoListenData.Text = "Data";
            this.rdoListenData.UseVisualStyleBackColor = false;
            this.rdoListenData.CheckedChanged += new System.EventHandler(this.rdoListenData_CheckedChanged);
            // 
            // btnClear
            // 
            this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClear.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnClear.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnClear.Location = new System.Drawing.Point(453, 294);
            this.btnClear.Name = "btnClear";
            this.btnClear.Size = new System.Drawing.Size(78, 30);
            this.btnClear.TabIndex = 21;
            this.btnClear.Text = "&Clear";
            this.btnClear.UseVisualStyleBackColor = false;
            this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
            // 
            // chkKeepAlive
            // 
            this.chkKeepAlive.AutoSize = true;
            this.chkKeepAlive.Location = new System.Drawing.Point(24, 104);
            this.chkKeepAlive.Name = "chkKeepAlive";
            this.chkKeepAlive.Size = new System.Drawing.Size(134, 17);
            this.chkKeepAlive.TabIndex = 11;
            this.chkKeepAlive.Text = "Keep Connection Alive";
            this.chkKeepAlive.UseVisualStyleBackColor = true;
            this.chkKeepAlive.CheckedChanged += new System.EventHandler(this.chkKeepAlive_CheckedChanged);
            // 
            // groupBox2
            // 
            this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox2.Controls.Add(this.chkKeepAlive);
            this.groupBox2.Controls.Add(this.grpNetwork);
            this.groupBox2.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.groupBox2.Location = new System.Drawing.Point(575, 241);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(176, 134);
            this.groupBox2.TabIndex = 29;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "Network";
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.BackColor = System.Drawing.SystemColors.ControlText;
            this.ClientSize = new System.Drawing.Size(784, 562);
            this.Controls.Add(this.groupBox2);
            this.Controls.Add(this.grpSerial);
            this.Controls.Add(this.groupBox1);
            this.Controls.Add(this.label7);
            this.Controls.Add(this.txtSyncResponse);
            this.Controls.Add(this.textBox2);
            this.Controls.Add(this.txtAsyncResponse);
            this.Controls.Add(this.grpConnection);
            this.Controls.Add(this.btnTransact);
            this.Controls.Add(this.btnClear);
            this.Controls.Add(this.btnDisconnect);
            this.Controls.Add(this.btnConnect);
            this.Controls.Add(this.btnSend);
            this.Controls.Add(this.label5);
            this.Controls.Add(this.label6);
            this.Name = "Form1";
            this.Text = "Alien Example 3 (Events)";
            this.Load += new System.EventHandler(this.Form1_Load);
            this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
            this.grpNetwork.ResumeLayout(false);
            this.grpNetwork.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.PortUD)).EndInit();
            this.grpSerial.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.ReceiveUP)).EndInit();
            this.grpConnection.ResumeLayout(false);
            this.groupBox1.ResumeLayout(false);
            this.groupBox2.ResumeLayout(false);
            this.groupBox2.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

		}

		[STAThread]
		static void Main() 
		{
			try
			{
				Application.Run(new Form1());
			}
			catch(Exception ex)
			{
				Trace.WriteLine(ex.Message);
			}
		}

		#endregion

		private void Form1_Load(object sender, System.EventArgs e)
		{
            string exePath = Application.ExecutablePath;
            int idx = exePath.LastIndexOf("\\");
            if (idx != -1)
                AlienLog.Path = exePath.Substring(0, idx + 1);
            AlienLog.WriteLine(true, "Starting the 'Ex3-Reader Events' application.");

            mReader = new clsReader(true);
            mReader.KeepNetworkConnectionAlive = true;

            mReaderInfo = mReader.ReaderSettings;
			mReader.Disconnected += new nsAlienRFID2.clsReader.DisconnectedEventHandler(mReader_Disconnected);
			mReader.Connected +=new nsAlienRFID2.clsReader.ConnectedEventHandler(mReader_Connected);
			cboPorts.SelectedIndex = 0;

			this.Text = "Alien Library .NET - Testing Reader Events";
			Thread.CurrentThread.Name = "Alien-Ex.3: Test Reader Events";

			mReader.ForceUpdates = true;
		}


		#region Reader Events
		private void mReader_Connected()
		{
			DisplayText("\r\nFrom Connected event:\r\n" + "---------------------------------\r\nConnected\r\n");
			btnDisconnect.Enabled = true;	
			btnConnect.Enabled = false;
			grpConnection.Enabled = true;
			btnTransact.Enabled = true;
			grpSerial.Enabled = false;
			grpNetwork.Enabled = false;
		}

		private void mReader_DataReceived(string data)
		{
			DisplayText("\r\nFrom DataReceived event:\r\n" + "----------------------------------------\r\n" + data);
		}
		private void mReader_MessageReceived(string data)
		{
			String stemp = "";
			if (data.Length > 1)
				stemp = "\r\nFrom MessageReceived event:\r\n" + "-------------------------------------------------\r\n" + data;
			else
				stemp = data;

			DisplayText(stemp);
		}

		private void mReader_Disconnected(string data)
		{
			DisplayText("\r\nFrom Disconnected event:\r\n" + "---------------------------------\r\n" + data);
		}

		#endregion

		private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (mReader != null)
			{
				// If uncommented next line with a heavy tag-streaming on SERIAL
                // when closing application will hang indefinitely because of a bug in .NET's SerialPort.
			    //mReader.Dispose();   
                mReader = null;
            }
		}

		private void MyUpDowns_ValueChanged(object sender, System.EventArgs e)
		{
			NumericUpDown who = (NumericUpDown)sender;
			if (who.Name == "PortUD")
			{
				mReaderInfo.TelnetPort = Convert.ToInt32(who.Value);
				mReader.ReaderSettings = mReaderInfo;
			}
			else
				mReader.ComTimeOutInterval = Convert.ToInt32(who.Value);
		}

		private void DisplayText(String data)
		{
			try
			{
				if (this.InvokeRequired)
				{
					object[] temp = {data};
					this.Invoke(new displayMessageDlgt(DisplayText),temp);
					return;
				}
				else
				{	//supress the login prompt after connecting
					if (data.IndexOf("Username>") != -1)
						data = data.Substring(0, data.Length - 10);

                    if (data.ToLower().Contains("connection closed") ||
                        data.ToLower().Contains("disconnected"))
                    {
                        btnDisconnect.Enabled = false;
                        btnConnect.Enabled = true;
                        grpConnection.Enabled = true;
                        btnSend.Enabled = false;
                        btnTransact.Enabled = false;
                        if (meReaderInterface == ComInterface.enumTCPIP)
                            grpNetwork.Enabled = true;
                        else
                            grpSerial.Enabled = true;
                    }
                    Application.DoEvents();
					txtAsyncResponse.AppendText(data.Replace("\0", ""));
					txtAsyncResponse.Focus();
					txtAsyncResponse.SelectAll();
					txtAsyncResponse.ScrollToCaret();
					this.Cursor = Cursors.Default;
					textBox2.Focus();
					return;
				}
			}
			catch(Exception ex)
			{
				Debug.WriteLine("Exception in the DiscplayText: " + ex.Message);
			}
		}

		
		private void btnConnect_Click(object sender, System.EventArgs e)
		{
			String result;
			this.Cursor = Cursors.WaitCursor;
			try		// extra precausion though it shouldn't throw exceptions
			{
				if (meReaderInterface == ComInterface.enumTCPIP)
					mReader.InitOnNetwork(textBox1.Text, Convert.ToInt32(PortUD.Value));
				else
					mReader.InitOnCom();

				DisplayText("\r\nConnecting to the reader...\r\n");
				this.Cursor = Cursors.WaitCursor;

				result = mReader.Connect();
				if (!mReader.IsConnected)
				{
					txtAsyncResponse.AppendText ("\r\nCan't connect\r\n");
				}
				else
				{
					if (meReaderInterface == ComInterface.enumTCPIP)
					{
						DisplayText("\r\nLogging in...\r\n");
						this.Cursor = Cursors.WaitCursor;
						if (!mReader.Login("alien", "password"))		//returns result synchronously
						{
							DisplayText ("\r\nLogin failed! Calling Disconnect()...\r\n");
							mReader.Disconnect();
							return;
						}
						DisplayText("\r\nLogged in - OK!\r\n");
					}
					btnDisconnect.Enabled = true;
					btnConnect.Enabled = false;
					grpConnection.Enabled = false;
					btnTransact.Enabled = true;
                    btnSend.Enabled = (rdoListenData.Checked || rdoListenMessages.Checked);
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
			this.Cursor = Cursors.Default;
		}


		private void btnDisconnect_Click(object sender, System.EventArgs e)
		{
			this.Cursor = Cursors.WaitCursor;
            // If uncommented next line with a heavy tag-streaming on SERIAL
            // when closing serial connection will hang indefinitely because of a bug in .NET's SerialPort.
            mReader.Disconnect();
			this.Cursor = Cursors.Default;	
			btnDisconnect.Enabled = false;	
			btnConnect.Enabled = true;
			grpConnection.Enabled = true;
			btnSend.Enabled = false;
			btnTransact.Enabled = false;
			if (meReaderInterface == ComInterface.enumTCPIP)
				grpNetwork.Enabled = true;
			else
				grpSerial.Enabled = true;
		}


		private void btnSend_Click(object sender, System.EventArgs e)
		{
            if (!rdoListenData.Checked && !rdoListenMessages.Checked)
            {
                MessageBox.Show("Please select what to listen for: data or message.");
                rdoListenMessages.Focus();
                return;
            }
			try
			{
				String stemp = textBox2.Text;
				mReader.Send(stemp, false);		
			}
			catch(Exception ex)
			{
				MessageBox.Show ("Exception thrown by Alien Library: " + ex.Message);
			}
		}

		private void btnTransact_Click(object sender, System.EventArgs e)
		{
            this.Cursor = Cursors.WaitCursor;
			try
			{
				txtSyncResponse.Text = mReader.SendReceive(textBox2.Text, false);		
			}
			catch( Exception ex)
			{
				MessageBox.Show ("Exception thrown by Alien Library: " + ex.Message);
			}
            this.Cursor = Cursors.Default;
		}

		private void rdoSerial_CheckedChanged(object sender, System.EventArgs e)
		{
			bool state = rdoSerial.Checked;
			grpSerial.Enabled = state;
			grpNetwork.Enabled = !state;
			btnConnect.Text = (state ? "Co&nnect" : "Co&nnect + Login");
			meReaderInterface = (state ? ComInterface.enumSerial : ComInterface.enumTCPIP);
			mReaderInfo.InterfaceType = meReaderInterface;
			mReader.ReaderSettings = mReaderInfo;
		}

		private void rdoTCP_CheckedChanged(object sender, System.EventArgs e)
		{
			bool state = rdoTCP.Checked;
			grpSerial.Enabled = !state;
			grpNetwork.Enabled = state;
			btnConnect.Text = (state ? "Co&nnect + Login" : "Co&nnect" );
			meReaderInterface = (state ? ComInterface.enumTCPIP : ComInterface.enumSerial);
			mReaderInfo.InterfaceType = meReaderInterface;
			mReader.ReaderSettings = mReaderInfo;
		}

		private void cboPorts_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			mReader.SerialPort = cboPorts.Text;
		}

		private void rdoListenData_CheckedChanged(object sender, System.EventArgs e)
		{
            btnSend.Enabled = true;

			bool state = rdoListenData.Checked;
			if (state)
				mReader.DataReceived +=new nsAlienRFID2.clsReader.DataReceivedEventHandler(mReader_DataReceived);
			else
				mReader.DataReceived -=new nsAlienRFID2.clsReader.DataReceivedEventHandler(mReader_DataReceived);
		}

		private void rdoListenMessages_CheckedChanged(object sender, System.EventArgs e)
		{
            btnSend.Enabled = true;

			bool state = rdoListenMessages.Checked;
			if (state)
				mReader.MessageReceived += new nsAlienRFID2.clsReader.MessageReceivedEventHandler(mReader_MessageReceived);
			else
				mReader.MessageReceived -= new nsAlienRFID2.clsReader.MessageReceivedEventHandler(mReader_MessageReceived);				
		}

		private void cboHostBaudRate_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cboHostBaudRate.Enabled)
				mReader.HostBaudRate = int.Parse(cboHostBaudRate.Text);
		}

        private void btnClear_Click(object sender, EventArgs e)
        {
            txtAsyncResponse.Clear();
            txtSyncResponse.Clear();
        }

        private void chkKeepAlive_CheckedChanged(object sender, EventArgs e)
        {
            mReader.KeepNetworkConnectionAlive = chkKeepAlive.Checked;
        }
	}
}
